<?php
if (!function_exists ('add_action')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit();
}


/**
 * Register styles and scripts
 */

function roofing_admin_scripts_init() {

    wp_register_script('bootstrap.min', get_template_directory_uri().'/js/bootstrap.min.js', array( 'jquery', 'jquery-ui-core', 'jquery-ui-widget', 'jquery-ui-mouse', 'jquery-ui-tabs', 'jquery-ui-droppable', 'jquery-ui-sortable' ) , false , false );

}
add_action('admin_init', 'roofing_admin_scripts_init');


class roofing_Import {

    public $message = "";
    public $attachments = false;


    function init_roofing_import() {
        if(isset($_REQUEST['import_option'])) {
            $import_option = $_REQUEST['import_option'];
            if($import_option == 'content'){
            }elseif($import_option == 'custom_sidebars') {
                $this->import_custom_sidebars('custom_sidebars.txt');
            } elseif($import_option == 'widgets') {
                $this->import_widgets('widgets.txt');
            } elseif($import_option == 'options'){
                $this->import_options('options.txt');
            }elseif($import_option == 'menus'){
                $this->import_menus('menus.txt');
            }elseif($import_option == 'settingpages'){
                $this->import_settings_pages('settingpages.txt');
            }elseif($import_option == 'complete_content'){
                $this->import_options('options.txt');
                $this->import_widgets('widgets.txt');
                $this->import_menus('menus.txt');
                $this->import_settings_pages('settingpages.txt');
                $this->message = esc_html__("Content imported successfully", "webdevia");
            }
        }
    }

    public function import_content($file){
        if (!class_exists('WP_Importer')) {
            ob_start();
            $class_wp_importer = ABSPATH . 'wp-admin/includes/class-wp-importer.php';
            require_once($class_wp_importer);
            require_once(plugin_dir_path( __FILE__ ) . '/class.wordpress-importer.php');
            $roofing_import = new WP_Import();
            set_time_limit(0);
            $path = plugin_dir_path( __FILE__ ) . '/files/' . $file;

            $roofing_import->fetch_attachments = $this->attachments;
            $returned_value = $roofing_import->import($path);
            if(is_wp_error($returned_value)){
                $this->message = esc_html__("An Error Occurred During Import", "webdevia");
            }
            else {
                $this->message = esc_html__("Content imported successfully", "webdevia");
            }
            ob_get_clean();
        } else {
            $this->message = esc_html__("Error loading files", "webdevia");
        }
    }

    public function import_widgets($file){

	    if(!file_exists(plugin_dir_path( __FILE__ ) . '/import/' . $file)) {
		    die("File not found");
	    } else {
		    $myfile = fopen( plugin_dir_path( __FILE__ ) . '/import/' . $file, "r" ) or die( "Unable to open file!" );
		    $data = fread( $myfile, filesize( plugin_dir_path( __FILE__ ) . '/import/' . $file ) );
		    fclose( $myfile );
	    }

	    /*
	    $data = file_get_contents( "./demo-files/widgets.txt", FILE_USE_INCLUDE_PATH );
	    $data = json_decode( $data );

	    // Delete import file
	    unlink( $file );*/

	    $data = json_decode( $data );


	    global $wp_registered_sidebars;

	    // Have valid data?
	    // If no data or could not decode
	    if ( empty( $data ) || ! is_object( $data ) ) {
		    wp_die(
			    esc_html__( 'Import data could not be read. Please try a different file.', 'widget-importer-exporter' ),
			    '',
			    array( 'back_link' => true )
		    );
	    }

	    // Hook before import
	    do_action( 'wie_before_import' );
	    $data = apply_filters( 'wie_import_data', $data );

	    // Get all available widgets site supports
	    $available_widgets = $this->roofing_available_widgets();

	    // Get all existing widget instances
	    $widget_instances = array();
	    foreach ( $available_widgets as $widget_data ) {
		    $widget_instances[$widget_data['id_base']] = get_option( 'widget_' . $widget_data['id_base'] );
	    }

	    // Begin results
	    $results = array();

	    // Loop import data's sidebars
	    foreach ( $data as $sidebar_id => $widgets ) {

		    // Skip inactive widgets
		    // (should not be in export file)
		    if ( 'wp_inactive_widgets' == $sidebar_id ) {
			    continue;
		    }

		    // Check if sidebar is available on this site
		    // Otherwise add widgets to inactive, and say so
		    if ( isset( $wp_registered_sidebars[$sidebar_id] ) ) {
			    $sidebar_available = true;
			    $use_sidebar_id = $sidebar_id;
			    $sidebar_message_type = 'success';
			    $sidebar_message = '';
		    } else {
			    $sidebar_available = false;
			    $use_sidebar_id = 'wp_inactive_widgets'; // add to inactive if sidebar does not exist in theme
			    $sidebar_message_type = 'error';
			    $sidebar_message = esc_html__( 'Sidebar does not exist in theme (using Inactive)', 'widget-importer-exporter' );
		    }

		    // Result for sidebar
		    $results[$sidebar_id]['name'] = ! empty( $wp_registered_sidebars[$sidebar_id]['name'] ) ? $wp_registered_sidebars[$sidebar_id]['name'] : $sidebar_id; // sidebar name if theme supports it; otherwise ID
		    $results[$sidebar_id]['message_type'] = $sidebar_message_type;
		    $results[$sidebar_id]['message'] = $sidebar_message;
		    $results[$sidebar_id]['widgets'] = array();

		    // Loop widgets
		    foreach ( $widgets as $widget_instance_id => $widget ) {

			    $fail = false;

			    // Get id_base (remove -# from end) and instance ID number
			    $id_base = preg_replace( '/-[0-9]+$/', '', $widget_instance_id );
			    $instance_id_number = str_replace( $id_base . '-', '', $widget_instance_id );

			    // Does site support this widget?
			    if ( ! $fail && ! isset( $available_widgets[$id_base] ) ) {
				    $fail = true;
				    $widget_message_type = 'error';
				    $widget_message = esc_html__( 'Site does not support widget', 'widget-importer-exporter' ); // explain why widget not imported
			    }

			    // Filter to modify settings object before conversion to array and import
			    // Leave this filter here for backwards compatibility with manipulating objects (before conversion to array below)
			    // Ideally the newer wie_widget_settings_array below will be used instead of this
			    $widget = apply_filters( 'wie_widget_settings', $widget ); // object

			    // Convert multidimensional objects to multidimensional arrays
			    // Some plugins like Jetpack Widget Visibility store settings as multidimensional arrays
			    // Without this, they are imported as objects and cause fatal error on Widgets page
			    // If this creates problems for plugins that do actually intend settings in objects then may need to consider other approach: https://wordpress.org/support/topic/problem-with-array-of-arrays
			    // It is probably much more likely that arrays are used than objects, however
			    $widget = json_decode( json_encode( $widget ), true );

			    // Filter to modify settings array
			    // This is preferred over the older wie_widget_settings filter above
			    // Do before identical check because changes may make it identical to end result (such as URL replacements)
			    $widget = apply_filters( 'wie_widget_settings_array', $widget );

			    // Does widget with identical settings already exist in same sidebar?
			    if ( ! $fail && isset( $widget_instances[$id_base] ) ) {

				    // Get existing widgets in this sidebar
				    $sidebars_widgets = get_option( 'sidebars_widgets' );
				    $sidebar_widgets = isset( $sidebars_widgets[$use_sidebar_id] ) ? $sidebars_widgets[$use_sidebar_id] : array(); // check Inactive if that's where will go

				    // Loop widgets with ID base
				    $single_widget_instances = ! empty( $widget_instances[$id_base] ) ? $widget_instances[$id_base] : array();
				    foreach ( $single_widget_instances as $check_id => $check_widget ) {

					    // Is widget in same sidebar and has identical settings?
					    if ( in_array( "$id_base-$check_id", $sidebar_widgets ) && (array) $widget == $check_widget ) {

						    $fail = true;
						    $widget_message_type = 'warning';
						    $widget_message = esc_html__( 'Widget already exists', 'widget-importer-exporter' ); // explain why widget not imported

						    break;

					    }

				    }

			    }

			    // No failure
			    if ( ! $fail ) {

				    // Add widget instance
				    $single_widget_instances = get_option( 'widget_' . $id_base ); // all instances for that widget ID base, get fresh every time
				    $single_widget_instances = ! empty( $single_widget_instances ) ? $single_widget_instances : array( '_multiwidget' => 1 ); // start fresh if have to
				    $single_widget_instances[] = $widget; // add it

				    // Get the key it was given
				    end( $single_widget_instances );
				    $new_instance_id_number = key( $single_widget_instances );

				    // If key is 0, make it 1
				    // When 0, an issue can occur where adding a widget causes data from other widget to load, and the widget doesn't stick (reload wipes it)
				    if ( '0' === strval( $new_instance_id_number ) ) {
					    $new_instance_id_number = 1;
					    $single_widget_instances[$new_instance_id_number] = $single_widget_instances[0];
					    unset( $single_widget_instances[0] );
				    }

				    // Move _multiwidget to end of array for uniformity
				    if ( isset( $single_widget_instances['_multiwidget'] ) ) {
					    $multiwidget = $single_widget_instances['_multiwidget'];
					    unset( $single_widget_instances['_multiwidget'] );
					    $single_widget_instances['_multiwidget'] = $multiwidget;
				    }

				    // Update option with new widget
				    update_option( 'widget_' . $id_base, $single_widget_instances );

				    // Assign widget instance to sidebar
				    $sidebars_widgets = get_option( 'sidebars_widgets' ); // which sidebars have which widgets, get fresh every time
				    $new_instance_id = $id_base . '-' . $new_instance_id_number; // use ID number from new widget instance
				    $sidebars_widgets[$use_sidebar_id][] = $new_instance_id; // add new instance to sidebar
				    update_option( 'sidebars_widgets', $sidebars_widgets ); // save the amended data

				    // Success message
				    if ( $sidebar_available ) {
					    $widget_message_type = 'success';
					    $widget_message = esc_html__( 'Imported', 'widget-importer-exporter' );
				    } else {
					    $widget_message_type = 'warning';
					    $widget_message = esc_html__( 'Imported to Inactive', 'widget-importer-exporter' );
				    }

			    }

			    // Result for widget instance
			    $results[$sidebar_id]['widgets'][$widget_instance_id]['name'] = isset( $available_widgets[$id_base]['name'] ) ? $available_widgets[$id_base]['name'] : $id_base; // widget name or ID if name not available (not supported by site)
			    $results[$sidebar_id]['widgets'][$widget_instance_id]['title'] = ! empty( $widget['title'] ) ? $widget['title'] : esc_html__( 'No Title', 'widget-importer-exporter' ); // show "No Title" if widget instance is untitled
			    $results[$sidebar_id]['widgets'][$widget_instance_id]['message_type'] = $widget_message_type;
			    $results[$sidebar_id]['widgets'][$widget_instance_id]['message'] = $widget_message;

		    }

	    }
    }

		public function roofing_available_widgets() {

			global $wp_registered_widget_controls;

			$widget_controls = $wp_registered_widget_controls;

			$available_widgets = array();

			foreach ( $widget_controls as $widget ) {

				if ( ! empty( $widget['id_base'] ) && ! isset( $available_widgets[$widget['id_base']] ) ) { // no dupes

					$available_widgets[$widget['id_base']]['id_base'] = $widget['id_base'];
					$available_widgets[$widget['id_base']]['name'] = $widget['name'];

				}

			}

			return apply_filters( 'wie_available_widgets', $available_widgets );

		}

    public function import_sidebars_widgets($file){
        $roofing_sidebars = get_option("sidebars_widgets");
        unset($roofing_sidebars['array_version']);
        $data = $this->file_options($file);
        if ( is_array($data['sidebars']) ) {
            $roofing_sidebars = array_merge( (array) $roofing_sidebars, (array) $data['sidebars'] );
            unset($roofing_sidebars['wp_inactive_widgets']);
            $roofing_sidebars = array_merge(array('wp_inactive_widgets' => array()), $roofing_sidebars);
            $roofing_sidebars['array_version'] = 2;
            wp_set_sidebars_widgets($roofing_sidebars);
        }
    }

    public function import_custom_sidebars($file){
        $options = $this->file_options($file);
        update_option( 'roofing_sidebars', $options);
        $this->message = esc_html__("Custom sidebars imported successfully", "webdevia");
    }

    public function import_options($file){
        $options = $this->file_options($file);
        update_option( 'roofing_options_wd', $options);
        $this->message = esc_html__("Options imported successfully", "webdevia");
    }

    public function import_menus($file){
        global $wpdb;
        $roofing_terms_table = $wpdb->prefix . "terms";
        $roofing_terms_table = esc_sql( $roofing_terms_table );
        $this->menus_data = $this->file_options($file);
        $menu_array = array();
        foreach ($this->menus_data as $registered_menu => $menu_slug) {
            $term_rows = $wpdb->get_results("SELECT * FROM $roofing_terms_table where slug='{$menu_slug}'", ARRAY_A);
            if(isset($term_rows[0]['term_id'])) {
                $term_id_by_slug = $term_rows[0]['term_id'];
            } else {
                $term_id_by_slug = null;
            }
            $menu_array[$registered_menu] = $term_id_by_slug;
        }
        set_theme_mod('nav_menu_locations', array_map('absint', $menu_array ) );

    }
    public function import_settings_pages($file){
        $pages = $this->file_options($file);

        foreach($pages as $roofing_page_option => $roofing_page_id){
            update_option( $roofing_page_option, $roofing_page_id);
        }
    }
    public function file_options($file){
        $file_content = "";
        $file_for_import = plugin_dir_path( __FILE__ ) . '/files/' . $file;
        if ( file_exists($file_for_import) ) {
            $file_content = $this->roofing_file_contents($file_for_import);
        } else {
            $this->message = esc_html__("File doesn't exist", "webdevia");
        }
        if ($file_content) {
            $unserialized_content = unserialize(base64_decode($file_content));
            $json_array = json_decode($file_content);
            /*print_r($json_array);*/
            /*if ($unserialized_content) {
                return $unserialized_content;
                
            }*/
            print_r($json_array);
        return $json_array;
        }
        /*return false;*/
    }

    function roofing_file_contents( $path ) {
        $roofing_content = '';
        if ( function_exists('realpath') )
            $filepath = realpath($path);
        if ( !$filepath || !@is_file($filepath) )
            return '';

        if( ini_get('allow_url_fopen') ) {
            $roofing_file_method = 'fopen';
        } else {
            $roofing_file_method = 'file_get_contents';
        }
        if ( $roofing_file_method == 'fopen' ) {
            $roofing_handle = fopen( $filepath, 'rb' );

            if( $roofing_handle !== false ) {
                while (!feof($roofing_handle)) {
                    $roofing_content .= fread($roofing_handle, 8192);
                }
                fclose( $roofing_handle );
            }
            return $roofing_content;
        } else {
            return file_get_contents($filepath);
        }
    }
}
global $my_roofing_Import;
$my_roofing_Import = new roofing_Import();



if(!function_exists('roofing_dataImport'))
{
    function roofing_dataImport()
    {
        global $my_roofing_Import;

        if ($_POST['import_attachments'] == 1)
            $my_roofing_Import->attachments = true;
        else
            $my_roofing_Import->attachments = false;

        $folder = "files/";
        if (!empty($_POST['example']))
            $folder = $_POST['example']."/";

        $my_roofing_Import->import_content($folder.$_POST['xml']);

        die();
    }

    add_action('wp_ajax_roofing_dataImport', 'roofing_dataImport');
}


if(!function_exists('roofing_menuImport'))
{
    function roofing_menuImport()
    {
        global $my_roofing_Import;

        if ($_POST['import_attachments'] == 1)
            $my_roofing_Import->attachments = true;
        else
            $my_roofing_Import->attachments = false;

        $folder = "files/";
        if (!empty($_POST['example']))
            $folder = $_POST['example']."/";

        $my_roofing_Import->import_content($folder.'menus.xml');


        $menuname = 'Main Menu';
				$menu_exists = wp_get_nav_menu_object( $menuname );

				$menu_id = $menu_exists->term_id;


				$locations = get_theme_mod('nav_menu_locations');
				$locations['primary'] = $menu_id;
				set_theme_mod( 'nav_menu_locations', $locations );

				

        die();
    }

    add_action('wp_ajax_roofing_menuImport', 'roofing_menuImport');
}

if(!function_exists('roofing_widgetsImport'))
{
    function roofing_widgetsImport()
    {
        global $my_roofing_Import;

        $folder = "/files/";
        if (!empty($_POST['example']))
            $folder .= $_POST['example']."/";

	     $my_roofing_Import->import_widgets($folder.'widgets.txt');

        die();
    }

    add_action('wp_ajax_roofing_widgetsImport', 'roofing_widgetsImport');
}

if(!function_exists('roofing_optionsImport'))
{
    function roofing_optionsImport()
    {
        global $my_roofing_Import;

        $folder = "/files/";
        if (!empty($_POST['example']))
            $folder .= $_POST['example']."/";

        $my_roofing_Import->import_options($folder.'options.txt');

        die();
    }

    add_action('wp_ajax_roofing_optionsImport', 'roofing_optionsImport');
}

if(!function_exists('roofing_otherImport'))
{
    function roofing_otherImport()
    {
        global $my_roofing_Import;

        $folder = "files/";
        if (!empty($_POST['example']))
            $folder .= $_POST['example']."/";

        $my_roofing_Import->import_options($folder.'options.txt');
        $my_roofing_Import->import_widgets($folder.'widgets.txt');
        $my_roofing_Import->import_menus($folder.'menu.txt');
        $my_roofing_Import->import_settings_pages($folder.'settingpages.txt');

        $menuname = 'Main Menu';
				$menu_exists = wp_get_nav_menu_object( $menuname );

				$menu_id = $menu_exists->term_id;


				$locations = get_theme_mod('nav_menu_locations');
				$locations['primary'] = $menu_id;
				set_theme_mod( 'nav_menu_locations', $locations );

        die();
    }

    add_action('wp_ajax_roofing_otherImport', 'roofing_otherImport');
}

if (!function_exists('roofing_import_options')) {
	function roofing_import_options()
	{
		global $my_roofing_Import;


    $folder = "files/";
    if (!empty($_POST['example'])) {
      	$demo_name = $_POST['example'];
    }
		if ($demo_name == 'primary') {
			$file = 'a:30:{s:21:"roofing_primary_color";s:18:"rgba(249,118,27,1)";s:23:"roofing_secondary_color";s:18:"rgba(32,152,209,1)";s:17:"roofing_logo_path";s:72:"http://localhost/roofing/wp-content/themes/Roofing/images/logo-white.png";s:25:"roofing_favicon_icon_path";s:69:"http://localhost/roofing/wp-content/themes/Roofing/images/favicon.png";s:18:"roofing_menu_style";s:0:"";s:16:"roofing_facebook";s:1:"#";s:15:"roofing_twitter";s:1:"#";s:19:"roofing_google_plus";s:1:"#";s:25:"roofing_body_font_familly";s:9:"Open Sans";s:24:"roofing_body_font_weight";s:0:"";s:30:"roofing_main-text-font-subsets";s:5:"latin";s:25:"roofing_head_font_familly";s:9:"Open Sans";s:33:"roofing_heading-font-weight-style";s:3:"700";s:33:"roofing_heading-text-font-subsets";s:5:"latin";s:31:"roofing_navigation_font_familly";s:9:"Open Sans";s:36:"roofing_navigation-font-weight-style";s:3:"400";s:36:"roofing_navigation-text-font-subsets";s:5:"latin";s:24:"roofing_theme_custom_css";s:226:".page-id-1083 .vc_custom_1465046301832 .wpb_single_image .vc_figure {
    position: relative;
    top: 30px;
}
.page-id-1083 .wd-footer {
 width: 64.6%;
margin : 0 auto;
}
.page-id-1061 .wd-footer {
display : none;
}";s:23:"roofing_theme_custom_js";s:0:"";s:22:"roofing_footer_columns";s:13:"three_columns";s:20:"roofing_nav_bg_color";s:18:"rgba(131,202,19,1)";s:17:"roofing_copyright";s:41:"© 2016 Roofing inc. All rights reserved.";s:27:"roofing_bg_single_post_path";s:0:"";s:13:"roofing_phone";s:11:"524 142 698";s:25:"roofing_font-weight-style";s:3:"400";s:22:"roofing_text-transform";s:4:"none";s:22:"roofing_body-font-size";s:7:"default";s:25:"roofing_heading-transform";s:4:"none";s:28:"roofing_navigation-transform";s:4:"none";s:28:"roofing_navigation-font-size";s:7:"default";}';
			// set the home page as front page
			$home = get_page_by_title('Home One');
		}





		if ($demo_name == 'creative') {
			$file = 'a:30:{s:21:"roofing_primary_color";s:18:"rgba(249,118,27,1)";s:23:"roofing_secondary_color";s:18:"rgba(32,152,209,1)";s:17:"roofing_logo_path";s:72:"http://localhost/roofing/wp-content/themes/Roofing/images/logo-white.png";s:25:"roofing_favicon_icon_path";s:69:"http://localhost/roofing/wp-content/themes/Roofing/images/favicon.png";s:18:"roofing_menu_style";s:0:"";s:16:"roofing_facebook";s:1:"#";s:15:"roofing_twitter";s:1:"#";s:19:"roofing_google_plus";s:1:"#";s:25:"roofing_body_font_familly";s:9:"Open Sans";s:24:"roofing_body_font_weight";s:0:"";s:30:"roofing_main-text-font-subsets";s:5:"latin";s:25:"roofing_head_font_familly";s:9:"Open Sans";s:33:"roofing_heading-font-weight-style";s:3:"700";s:33:"roofing_heading-text-font-subsets";s:5:"latin";s:31:"roofing_navigation_font_familly";s:9:"Open Sans";s:36:"roofing_navigation-font-weight-style";s:3:"400";s:36:"roofing_navigation-text-font-subsets";s:5:"latin";s:24:"roofing_theme_custom_css";s:226:".page-id-1083 .vc_custom_1465046301832 .wpb_single_image .vc_figure {
    position: relative;
    top: 30px;
}
.page-id-1083 .wd-footer {
 width: 64.6%;
margin : 0 auto;
}
.page-id-1061 .wd-footer {
display : none;
}";s:23:"roofing_theme_custom_js";s:0:"";s:22:"roofing_footer_columns";s:13:"three_columns";s:20:"roofing_nav_bg_color";s:18:"rgba(131,202,19,1)";s:17:"roofing_copyright";s:41:"© 2016 Roofing inc. All rights reserved.";s:27:"roofing_bg_single_post_path";s:0:"";s:13:"roofing_phone";s:11:"524 142 698";s:25:"roofing_font-weight-style";s:3:"400";s:22:"roofing_text-transform";s:4:"none";s:22:"roofing_body-font-size";s:7:"default";s:25:"roofing_heading-transform";s:4:"none";s:28:"roofing_navigation-transform";s:4:"none";s:28:"roofing_navigation-font-size";s:7:"default";}';
			// set the home page as front page
			$home = get_page_by_title('Home Two');
		}




		if ($demo_name == 'financial') {
			$file = 'a:30:{s:21:"roofing_primary_color";s:18:"rgba(249,118,27,1)";s:23:"roofing_secondary_color";s:18:"rgba(32,152,209,1)";s:17:"roofing_logo_path";s:72:"http://localhost/roofing/wp-content/themes/Roofing/images/logo-white.png";s:25:"roofing_favicon_icon_path";s:69:"http://localhost/roofing/wp-content/themes/Roofing/images/favicon.png";s:18:"roofing_menu_style";s:0:"";s:16:"roofing_facebook";s:1:"#";s:15:"roofing_twitter";s:1:"#";s:19:"roofing_google_plus";s:1:"#";s:25:"roofing_body_font_familly";s:9:"Open Sans";s:24:"roofing_body_font_weight";s:0:"";s:30:"roofing_main-text-font-subsets";s:5:"latin";s:25:"roofing_head_font_familly";s:9:"Open Sans";s:33:"roofing_heading-font-weight-style";s:3:"700";s:33:"roofing_heading-text-font-subsets";s:5:"latin";s:31:"roofing_navigation_font_familly";s:9:"Open Sans";s:36:"roofing_navigation-font-weight-style";s:3:"400";s:36:"roofing_navigation-text-font-subsets";s:5:"latin";s:24:"roofing_theme_custom_css";s:226:".page-id-1083 .vc_custom_1465046301832 .wpb_single_image .vc_figure {
    position: relative;
    top: 30px;
}
.page-id-1083 .wd-footer {
 width: 64.6%;
margin : 0 auto;
}
.page-id-1061 .wd-footer {
display : none;
}";s:23:"roofing_theme_custom_js";s:0:"";s:22:"roofing_footer_columns";s:13:"three_columns";s:20:"roofing_nav_bg_color";s:18:"rgba(131,202,19,1)";s:17:"roofing_copyright";s:41:"© 2016 Roofing inc. All rights reserved.";s:27:"roofing_bg_single_post_path";s:0:"";s:13:"roofing_phone";s:11:"524 142 698";s:25:"roofing_font-weight-style";s:3:"400";s:22:"roofing_text-transform";s:4:"none";s:22:"roofing_body-font-size";s:7:"default";s:25:"roofing_heading-transform";s:4:"none";s:28:"roofing_navigation-transform";s:4:"none";s:28:"roofing_navigation-font-size";s:7:"default";}';

		// set the home page as front page
		$home = get_page_by_title('Home three');
		}
		if ($demo_name == 'print') {
			$file = 'a:30:{s:21:"roofing_primary_color";s:18:"rgba(249,118,27,1)";s:23:"roofing_secondary_color";s:18:"rgba(32,152,209,1)";s:17:"roofing_logo_path";s:72:"http://localhost/roofing/wp-content/themes/Roofing/images/logo-white.png";s:25:"roofing_favicon_icon_path";s:69:"http://localhost/roofing/wp-content/themes/Roofing/images/favicon.png";s:18:"roofing_menu_style";s:0:"";s:16:"roofing_facebook";s:1:"#";s:15:"roofing_twitter";s:1:"#";s:19:"roofing_google_plus";s:1:"#";s:25:"roofing_body_font_familly";s:9:"Open Sans";s:24:"roofing_body_font_weight";s:0:"";s:30:"roofing_main-text-font-subsets";s:5:"latin";s:25:"roofing_head_font_familly";s:9:"Open Sans";s:33:"roofing_heading-font-weight-style";s:3:"700";s:33:"roofing_heading-text-font-subsets";s:5:"latin";s:31:"roofing_navigation_font_familly";s:9:"Open Sans";s:36:"roofing_navigation-font-weight-style";s:3:"400";s:36:"roofing_navigation-text-font-subsets";s:5:"latin";s:24:"roofing_theme_custom_css";s:226:".page-id-1083 .vc_custom_1465046301832 .wpb_single_image .vc_figure {
    position: relative;
    top: 30px;
}
.page-id-1083 .wd-footer {
 width: 64.6%;
margin : 0 auto;
}
.page-id-1061 .wd-footer {
display : none;
}";s:23:"roofing_theme_custom_js";s:0:"";s:22:"roofing_footer_columns";s:13:"three_columns";s:20:"roofing_nav_bg_color";s:18:"rgba(131,202,19,1)";s:17:"roofing_copyright";s:41:"© 2016 Roofing inc. All rights reserved.";s:27:"roofing_bg_single_post_path";s:0:"";s:13:"roofing_phone";s:11:"524 142 698";s:25:"roofing_font-weight-style";s:3:"400";s:22:"roofing_text-transform";s:4:"none";s:22:"roofing_body-font-size";s:7:"default";s:25:"roofing_heading-transform";s:4:"none";s:28:"roofing_navigation-transform";s:4:"none";s:28:"roofing_navigation-font-size";s:7:"default";}';

		// set the home page as front page
		$home = get_page_by_title('Home Four');
		}
		if ($demo_name == 'agency') {
			$file = 'a:30:{s:21:"roofing_primary_color";s:18:"rgba(249,118,27,1)";s:23:"roofing_secondary_color";s:18:"rgba(32,152,209,1)";s:17:"roofing_logo_path";s:72:"http://localhost/roofing/wp-content/themes/Roofing/images/logo-white.png";s:25:"roofing_favicon_icon_path";s:69:"http://localhost/roofing/wp-content/themes/Roofing/images/favicon.png";s:18:"roofing_menu_style";s:0:"";s:16:"roofing_facebook";s:1:"#";s:15:"roofing_twitter";s:1:"#";s:19:"roofing_google_plus";s:1:"#";s:25:"roofing_body_font_familly";s:9:"Open Sans";s:24:"roofing_body_font_weight";s:0:"";s:30:"roofing_main-text-font-subsets";s:5:"latin";s:25:"roofing_head_font_familly";s:9:"Open Sans";s:33:"roofing_heading-font-weight-style";s:3:"700";s:33:"roofing_heading-text-font-subsets";s:5:"latin";s:31:"roofing_navigation_font_familly";s:9:"Open Sans";s:36:"roofing_navigation-font-weight-style";s:3:"400";s:36:"roofing_navigation-text-font-subsets";s:5:"latin";s:24:"roofing_theme_custom_css";s:226:".page-id-1083 .vc_custom_1465046301832 .wpb_single_image .vc_figure {
    position: relative;
    top: 30px;
}
.page-id-1083 .wd-footer {
 width: 64.6%;
margin : 0 auto;
}
.page-id-1061 .wd-footer {
display : none;
}";s:23:"roofing_theme_custom_js";s:0:"";s:22:"roofing_footer_columns";s:13:"three_columns";s:20:"roofing_nav_bg_color";s:18:"rgba(131,202,19,1)";s:17:"roofing_copyright";s:41:"© 2016 Roofing inc. All rights reserved.";s:27:"roofing_bg_single_post_path";s:0:"";s:13:"roofing_phone";s:11:"524 142 698";s:25:"roofing_font-weight-style";s:3:"400";s:22:"roofing_text-transform";s:4:"none";s:22:"roofing_body-font-size";s:7:"default";s:25:"roofing_heading-transform";s:4:"none";s:28:"roofing_navigation-transform";s:4:"none";s:28:"roofing_navigation-font-size";s:7:"default";}';
		// set the home page as front page
		$home = get_page_by_title('Home Five');
		}

		

		$options_array = array();

		$options_array = unserialize($file);
		update_option("wd_options_array",$options_array);
		
		update_option('page_on_front',$home->ID);
		update_option('show_on_front','page');
		
		// set the blog page
		$blog = get_page_by_title('Blog');
		update_option('page_for_posts',$blog->ID);
	}
	add_action('wp_ajax_roofing_import_options', 'roofing_import_options');
}