<?php
function my_theme_enqueue_styles() {

    $parent_style = 'parent-style'; // This is 'twentyfifteen-style' for the Twenty Fifteen theme.

    wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' );
    wp_enqueue_style( 'child-style',
        get_stylesheet_directory_uri() . '/style.css',
        array( $parent_style ),
        wp_get_theme()->get('Version')
    );
}
add_action( 'wp_enqueue_scripts', 'my_theme_enqueue_styles' );

function lemoon_include_myuploadscript() {

    if ( ! did_action( 'wp_enqueue_media' ) ) {
        wp_enqueue_media();
    }

    wp_enqueue_script( 'myuploadscript', get_stylesheet_directory_uri() . '/lemoonlogoupdater.js', array('jquery'), null, false );
}

add_action( 'admin_enqueue_scripts', 'lemoon_include_myuploadscript' );

function lemoon_image_uploader_field( $name, $value = '') {
    $image = ' button">Upload image';
    $image_size = 'full'; 
    $display = 'none'; 

    if( $image_attributes = wp_get_attachment_image_src( $value, $image_size ) ) {


        $image = '"><img src="' . $image_attributes[0] . '" style="max-width:95%;display:block;" />';
        $display = 'inline-block';

    } 

    return '
    <div>
        <a href="#" class="lemoon_upload_image_button' . $image . '</a>
        <input type="hidden" name="' . $name . '" id="' . $name . '" value="' . $value . '" />
        <a href="#" class="lemoon_remove_image_button" style="display:inline-block;display:' . $display . '">Remove image</a>
    </div>';
}

add_action( 'admin_menu', 'lemoon_meta_box_add' );

function lemoon_meta_box_add() {
    add_meta_box('lemoondiv', // meta box ID
        'Custom logo', // meta box title
        'lemoon_print_box', // callback function that prints the meta box HTML 
        'page', // post type where to add it
        'normal', // priority
        'high' ); // position
}

function lemoon_print_box( $post ) {
    $meta_key = 'second_featured_img';
    echo lemoon_image_uploader_field( $meta_key, get_post_meta($post->ID, $meta_key, true) );
}

add_action('save_post', 'lemoon_save');

function lemoon_save( $post_id ) {
    if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ) 
        return $post_id;

    $meta_key = 'second_featured_img';

    update_post_meta( $post_id, $meta_key, $_POST[$meta_key] );
    return $post_id;
}
?>